
-- Rain parameters
kPPS = 1000;               -- Number of particles generated per second
kGravity = 1200 ;            -- Gravity in pixels/second/second

-- kBlendNormal
-- kBlendOpaque
-- kBlendAdditive
-- kBlendAdditiveAlpha
-- kBlendSubtractive
-- kBlendLit

function Init()
  SetTexture("cork");
  SetBlendMode(kBlendNormal);
  SetNumParticles(1);
end

floor = math.floor

ParticlesPerSecond = NewParticleGenerator();

StopSpouting = NewTimeout(1800);
TestDone = NewTimeout(8000);

function Update(ms)
  if (TestDone(ms)) then
    SetDone();
    return ;
  end
  local newParticles = ParticlesPerSecond( kPPS,ms );

  if (not StopSpouting(ms)) then
   InitScale( "fRange", .4, .4 );
   InitAge("iRange", 500,1200);
   InitExtra1("fRange",0,1);
   InitPosition( "vRange", Vec3(0,0,0), Vec3(0,0,0) );
   InitVelocity( "vRange", Vec3(10,-1000,0), Vec3(100, -600, 0));
   CreateParticles(newParticles);
  end

  Gravity(kGravity);

   Do("move");
   DoAge("iAge");
   DoScale("fScale",
      .6, 20,
      14, 500);


   Do("expire", 6000)

   DoUp( "vRotate", -3, 3 );

end

